// SnapPreviewControls.cpp : implementation file
//

#include "stdafx.h"
#include "Resource.h"
#include "SnapPreviewControls.h"

#define IDC_BTN_COLORPICK		0x100
#define ID_PLAYBACK_TIMER		1



// SnapPreviewDialog
IMPLEMENT_DYNAMIC(CSnapPreviewDialog, CXTResizeDialog)

BEGIN_MESSAGE_MAP(CSnapPreviewDialog, CXTResizeDialog)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_WM_HSCROLL()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_SVB_FOLDER, &CSnapPreviewDialog::OnBnFolderClicked)
	ON_BN_CLICKED(IDC_SVCHK_KEEPASPECTR, &CSnapPreviewDialog::OnBnClickedSvchkKeepaspectr)
	ON_BN_CLICKED(IDC_SVCHK_UPDATETEXT, &CSnapPreviewDialog::OnBnClickedSvchkUpdatetext)
	ON_CPN_XT_SELENDOK(IDC_BTN_COLORPICK, &CSnapPreviewDialog::OnBnClickedColorPicker)
	ON_BN_CLICKED(IDC_SVCHK_UPDATEIMAGES, &CSnapPreviewDialog::OnBnClickedSvchkUpdateimages)
	ON_WM_CTLCOLOR()
END_MESSAGE_MAP()



// CSnapPreviewDialog construction & destruction
CSnapPreviewDialog::CSnapPreviewDialog(CWnd *pParent /* = NULL */):
		CXTResizeDialog(CSnapPreviewDialog::IDD, pParent)
	, m_strFolder(_T(""))
	, m_bUpdateText(FALSE)
	, m_bKeepAspectR(FALSE)
	, m_bUpdateImages(FALSE)
		{
	m_bmPlayerBtns.LoadBitmap(IDB_SV_PLAYER);
	m_pCD = 0;
	m_rcPlayer.SetRect(10, 10, 166, 36);
	m_nEnabled			= kSVPB_NONE;
	m_eDown					= kSVPB_NONE;
	m_nPlayerClick	= 0;

	CRect rcTarget(11, 11, 35, 35);
	for (int i = 0; i < 6; ++i)
	{
		m_arrButtons[i] = rcTarget;
		m_arrButtons[i].OffsetRect(26*i, 0);
	}
}

CSnapPreviewDialog::~CSnapPreviewDialog()
{
}



// CSnapPreviewDialog operations
void CSnapPreviewDialog::EnablePlayerButtons()
{
	if (m_pCD->eState == kUNINITIALIZED)
		m_nEnabled = kSVPB_NONE;
	else if (m_pCD->eState == kPLAYING)
		m_nEnabled = kSVPB_STOP;
	else
	{
		m_nEnabled = kSVPB_PLAY;
		if (m_pCD->nCurFrame > 0)
			m_nEnabled |= kSVPB_FIRST | kSVPB_PREV;
		if (m_pCD->nCurFrame < m_pCD->nLastFrame)
			m_nEnabled |= kSVPB_NEXT | kSVPB_LAST;
	}

	m_eDown = kSVPB_NONE;
	DrawPlayerButtons(kSVPB_ALL);
}

void CSnapPreviewDialog::DrawPlayerButtons(ENM_PLAYER_BUTTONS eb)
{
	InvalidateRect(m_rcPlayer);

	static COLORREF clrBR = RGB(200,200,200), clrTL = RGB(60,60,60), clrDis = RGB(175,175,175);
	static CBitmap bmNull;
	static CRect rcTarget(1, 1, 25, 25);

	if (eb & kSVPB_FIRST)
	{
		static POINT arr[] =
		{
			{23, 3},
			{3, 3},
			{23, 23},
		};

		if (m_nEnabled & kSVPB_FIRST)	// enabled
		{
			m_dcControlBoard.PlgBlt(arr, &m_dcPlayerBtns, 120, 0, 20, 20, bmNull, 0, 0);
			if (m_eDown == kSVPB_FIRST)
				m_dcControlBoard.Draw3dRect(rcTarget, clrTL, clrBR);	// down
			else
				m_dcControlBoard.Draw3dRect(rcTarget, clrBR, clrTL);	// up
		}
		else	// disabled
		{
			m_dcControlBoard.PlgBlt(arr, &m_dcPlayerBtns, 140, 0, 20, 20, bmNull, 0, 0);
			m_dcControlBoard.Draw3dRect(rcTarget, clrDis, clrDis);
		}
	}
	if (eb & kSVPB_PREV)
	{
		static POINT arr[] =
		{
			{49, 3},
			{29, 3},
			{49, 23},
		};
		CRect rcTmp(rcTarget);
		rcTmp.OffsetRect(26, 0);

		if (m_nEnabled & kSVPB_PREV)	// enabled
		{
			m_dcControlBoard.PlgBlt(arr, &m_dcPlayerBtns, 80, 0, 20, 20, bmNull, 0, 0);
			if (m_eDown == kSVPB_PREV)
				m_dcControlBoard.Draw3dRect(rcTmp, clrTL, clrBR);	// down
			else
				m_dcControlBoard.Draw3dRect(rcTmp, clrBR, clrTL);	// up
		}
		else	// disabled
		{
			m_dcControlBoard.PlgBlt(arr, &m_dcPlayerBtns, 100, 0, 20, 20, bmNull, 0, 0);
			m_dcControlBoard.Draw3dRect(rcTmp, clrDis, clrDis);
		}
	}
	if (eb & kSVPB_PLAY)
	{
		CRect rcTmp(rcTarget);
		rcTmp.OffsetRect(2*26, 0);

		if (m_nEnabled & kSVPB_PLAY)	// enabled
		{
			m_dcControlBoard.BitBlt(2*26+3, 3, 20, 20, &m_dcPlayerBtns, 0, 0, SRCCOPY);
			if (m_eDown == kSVPB_PLAY)
				m_dcControlBoard.Draw3dRect(rcTmp, clrTL, clrBR);	// down
			else
				m_dcControlBoard.Draw3dRect(rcTmp, clrBR, clrTL);	// up
		}
		else	// disabled
		{
			m_dcControlBoard.BitBlt(2*26+3, 3, 20, 20, &m_dcPlayerBtns, 20, 0, SRCCOPY);
			m_dcControlBoard.Draw3dRect(rcTmp, clrDis, clrDis);
		}
	}
	if (eb & kSVPB_STOP)
	{
		CRect rcTmp(rcTarget);
		rcTmp.OffsetRect(3*26, 0);

		if (m_nEnabled & kSVPB_STOP)	// enabled
		{
			m_dcControlBoard.BitBlt(3*26+3, 3, 20, 20, &m_dcPlayerBtns, 40, 0, SRCCOPY);
			if (m_eDown == kSVPB_STOP)
				m_dcControlBoard.Draw3dRect(rcTmp, clrTL, clrBR);	// down
			else
				m_dcControlBoard.Draw3dRect(rcTmp, clrBR, clrTL);	// up
		}
		else	// disabled
		{
			m_dcControlBoard.BitBlt(3*26+3, 3, 20, 20, &m_dcPlayerBtns, 60, 0, SRCCOPY);
			m_dcControlBoard.Draw3dRect(rcTmp, clrDis, clrDis);
		}
	}
	if (eb & kSVPB_NEXT)
	{
		CRect rcTmp(rcTarget);
		rcTmp.OffsetRect(4*26, 0);

		if (m_nEnabled & kSVPB_NEXT)	// enabled
		{
			m_dcControlBoard.BitBlt(4*26+3, 3, 20, 20, &m_dcPlayerBtns, 80, 0, SRCCOPY);
			if (m_eDown == kSVPB_NEXT)
				m_dcControlBoard.Draw3dRect(rcTmp, clrTL, clrBR);	// down
			else
				m_dcControlBoard.Draw3dRect(rcTmp, clrBR, clrTL);	// up
		}
		else	// disabled
		{
			m_dcControlBoard.BitBlt(4*26+3, 3, 20, 20, &m_dcPlayerBtns, 100, 0, SRCCOPY);
			m_dcControlBoard.Draw3dRect(rcTmp, clrDis, clrDis);
		}
	}
	if (eb & kSVPB_LAST)
	{
		CRect rcTmp(rcTarget);
		rcTmp.OffsetRect(5*26, 0);

		if (m_nEnabled & kSVPB_LAST)	// enabled
		{
			m_dcControlBoard.BitBlt(5*26+3, 3, 20, 20, &m_dcPlayerBtns, 120, 0, SRCCOPY);
			if (m_eDown == kSVPB_LAST)
				m_dcControlBoard.Draw3dRect(rcTmp, clrTL, clrBR);	// down
			else
				m_dcControlBoard.Draw3dRect(rcTmp, clrBR, clrTL);	// up
		}
		else	// disabled
		{
			m_dcControlBoard.BitBlt(5*26+3, 3, 20, 20, &m_dcPlayerBtns, 140, 0, SRCCOPY);
			m_dcControlBoard.Draw3dRect(rcTmp, clrDis, clrDis);
		}
	}
}

void CSnapPreviewDialog::OnPlayerFirst()
{
	m_pCD->nCurFrame = 0;
	EnablePlayerButtons();
	GetOwner()->SendMessage(UWM_BUTTON_CLICKED, 0, kMSG_FRAME_CHANGED);	// Navigation

	m_sldFrame.SetPos(m_pCD->nCurFrame);
	CString strTmp;
	strTmp.Format("%d/%d", m_pCD->nCurFrame, m_pCD->nLastFrame);
	SetDlgItemText(IDC_SVSTATIC_FRAME, strTmp);
}

void CSnapPreviewDialog::OnPlayerPrev()
{
	m_pCD->nCurFrame--;
	EnablePlayerButtons();
	GetOwner()->SendMessage(UWM_BUTTON_CLICKED, 0, kMSG_FRAME_CHANGED);	// Navigation

	m_sldFrame.SetPos(m_pCD->nCurFrame);
	CString strTmp;
	strTmp.Format("%d/%d", m_pCD->nCurFrame, m_pCD->nLastFrame);
	SetDlgItemText(IDC_SVSTATIC_FRAME, strTmp);
}

void CSnapPreviewDialog::OnPlayerPlay()
{
	SetTimer(ID_PLAYBACK_TIMER, 10, 0);

	m_pCD->eState = kPLAYING;
	EnablePlayerButtons();
	m_nTimerVar = 1;
}

void CSnapPreviewDialog::OnPlayerStop()
{
	KillTimer(ID_PLAYBACK_TIMER);
	m_pCD->eState = kACTIVE;
	EnablePlayerButtons();
}

void CSnapPreviewDialog::OnPlayerNext()
{
	m_pCD->nCurFrame++;
	EnablePlayerButtons();
	GetOwner()->SendMessage(UWM_BUTTON_CLICKED, 0, kMSG_FRAME_CHANGED);	// Navigation

	m_sldFrame.SetPos(m_pCD->nCurFrame);
	CString strTmp;
	strTmp.Format("%d/%d", m_pCD->nCurFrame, m_pCD->nLastFrame);
	SetDlgItemText(IDC_SVSTATIC_FRAME, strTmp);
}

void CSnapPreviewDialog::OnPlayerLast()
{
	m_pCD->nCurFrame = m_pCD->nLastFrame;
	EnablePlayerButtons();
	GetOwner()->SendMessage(UWM_BUTTON_CLICKED, 0, kMSG_FRAME_CHANGED);	// Navigation

	m_sldFrame.SetPos(m_pCD->nCurFrame);
	CString strTmp;
	strTmp.Format("%d/%d", m_pCD->nCurFrame, m_pCD->nLastFrame);
	SetDlgItemText(IDC_SVSTATIC_FRAME, strTmp);
}



// CSnapPreviewDialog virtual overrides
void CSnapPreviewDialog::DoDataExchange(CDataExchange* pDX)
{
	CXTResizeDialog::DoDataExchange(pDX);

	DDX_Text(pDX, IDC_SVEDIT_FOLDERPATH, m_strFolder);
	DDX_Control(pDX, IDC_SVSLIDER_SPEED, m_sldSpeed);
	DDX_Control(pDX, IDC_SVSLIDER_CURFRAME, m_sldFrame);
	DDX_Check(pDX, IDC_SVCHK_UPDATETEXT, m_bUpdateText);
	DDX_Check(pDX, IDC_SVCHK_KEEPASPECTR, m_bKeepAspectR);
	DDX_Control(pDX, IDC_BTN_COLORPICK, m_colorPickBtn);
	DDX_Check(pDX, IDC_SVCHK_UPDATEIMAGES, m_bUpdateImages);
}

BOOL CSnapPreviewDialog::OnInitDialog()
{
	// Create the color pick button (before calling base::OnInitDialog())
	CRect rcColor, rcBtn;
	GetDlgItem(IDC_SVCHK_UPDATETEXT)->GetWindowRect(rcColor);
	ScreenToClient(rcColor);
	rcBtn.SetRect(rcColor.right + 25, rcColor.top, rcColor.right + 120, rcColor.top + 35);
	m_colorPickBtn.Create("Background", BS_TEXT | BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE, rcBtn, this, IDC_BTN_COLORPICK);
	m_colorPickBtn.ShowText(TRUE);
	m_colorPickBtn.SetColor(RGB(0,0,0));
	m_colorPickBtn.SetDefaultColor(RGB(0,0,0));
	m_colorPickBtn.SetOwner(this);

	CXTResizeDialog::OnInitDialog();

	// Initialize dialog controls
	m_strFolder = "not set";
	SetResize(IDC_SVEDIT_FOLDERPATH, SZ_TOP_LEFT, SZ_TOP_RIGHT);
	SetResize(IDC_SVSLIDER_CURFRAME, SZ_TOP_LEFT, SZ_TOP_RIGHT);

	m_sldSpeed.EnableWindow(FALSE);
	m_sldSpeed.SetRange(-100, 100);
	m_sldSpeed.SetPos(100);
	m_sldFrame.EnableWindow(FALSE);

	SetDlgItemText(IDC_SVSTATIC_SPEED, "0.00");

	m_bUpdateText		= TRUE;
	m_bKeepAspectR	= TRUE;
	m_bUpdateImages	= TRUE;
	UpdateData(FALSE);

	GetDlgItem(IDC_SVCHK_UPDATETEXT)->EnableWindow(FALSE);
	GetDlgItem(IDC_SVCHK_UPDATEIMAGES)->EnableWindow(FALSE);
	GetDlgItem(IDC_SVCHK_KEEPASPECTR)->EnableWindow(FALSE);

	// Create necessary DCs and bitmaps
	CClientDC dc(this);
	m_dcControlBoard.CreateCompatibleDC(&dc);
	m_dcPlayerBtns.CreateCompatibleDC(&dc);
	m_bmControlBoard.CreateCompatibleBitmap(&dc, 156, 26);
	m_pBmCB = m_dcControlBoard.SelectObject(&m_bmControlBoard);
	m_pBmPB = m_dcPlayerBtns.SelectObject(&m_bmPlayerBtns);

	m_dcControlBoard.SelectStockObject(DC_PEN);
	m_dcControlBoard.SelectStockObject(DC_BRUSH);
	m_dcControlBoard.SetDCPenColor(RGB(0,0,0));
	m_dcControlBoard.SetDCBrushColor(RGB(150,150,150));
	m_dcControlBoard.Rectangle(0,0,156,26);
	m_dcControlBoard.SelectStockObject(NULL_BRUSH);

	DrawPlayerButtons(kSVPB_ALL);

	m_brSlider.CreateSolidBrush(RGB(200,200,205));

	// Create the tool tips
	m_ctlTT.CreateEx(this, WS_POPUP | TTS_ALWAYSTIP | TTS_NOPREFIX, WS_EX_TOPMOST);
	m_ctlTT.SetDelayTime(500);
	static LPCTSTR szToolTips[] = { "First Frame", "Previous Frame", "Play", "Stop", "Next Frame", "Last Frame" };
	for (int i = 0; i < 6; ++i)
		m_ctlTT.AddRectTool(this, szToolTips[i], m_arrButtons[i], 1);

	return TRUE;
}



// CSnapPreviewDialog message handlers
void CSnapPreviewDialog::OnPaint()
{
	CPaintDC dc(this);

	dc.BitBlt(10, 10, 156, 26, &m_dcControlBoard, 0, 0, SRCCOPY);
}

void CSnapPreviewDialog::OnLButtonDown(UINT nFlags, CPoint point)
{
	if ((m_nEnabled & kSVPB_FIRST) && m_arrButtons[0].PtInRect(point))	// kSVPB_FIRST
	{
		SetCapture();
		m_nPlayerClick = 1;
		m_eDown = kSVPB_FIRST;
		DrawPlayerButtons(kSVPB_FIRST);
	}
	else if ((m_nEnabled & kSVPB_PREV) && m_arrButtons[1].PtInRect(point))	// kSVPB_PREV
	{
		SetCapture();
		m_nPlayerClick = 2;
		m_eDown = kSVPB_PREV;
		DrawPlayerButtons(kSVPB_PREV);
	}
	else if ((m_nEnabled & kSVPB_PLAY) && m_arrButtons[2].PtInRect(point))	// kSVPB_PLAY
	{
		SetCapture();
		m_nPlayerClick = 3;
		m_eDown = kSVPB_PLAY;
		DrawPlayerButtons(kSVPB_PLAY);
	}
	else if ((m_nEnabled & kSVPB_STOP) && m_arrButtons[3].PtInRect(point))	// kSVPB_STOP
	{
		SetCapture();
		m_nPlayerClick = 4;
		m_eDown = kSVPB_STOP;
		DrawPlayerButtons(kSVPB_STOP);
	}
	else if ((m_nEnabled & kSVPB_NEXT) && m_arrButtons[4].PtInRect(point))	// kSVPB_NEXT
	{
		SetCapture();
		m_nPlayerClick = 5;
		m_eDown = kSVPB_NEXT;
		DrawPlayerButtons(kSVPB_NEXT);
	}
	else if ((m_nEnabled & kSVPB_LAST) && m_arrButtons[5].PtInRect(point))	// kSVPB_LAST
	{
		SetCapture();
		m_nPlayerClick = 6;
		m_eDown = kSVPB_LAST;
		DrawPlayerButtons(kSVPB_LAST);
	}

	CXTResizeDialog::OnLButtonDown(nFlags, point);
}

void CSnapPreviewDialog::OnMouseMove(UINT nFlags, CPoint point)
{
	if (m_nPlayerClick)
	{
		if (m_arrButtons[m_nPlayerClick-1].PtInRect(point) && (m_eDown == kSVPB_NONE))
		{
			switch (m_nPlayerClick)
			{
			case 1:	m_eDown = kSVPB_FIRST;	break;
			case 2:	m_eDown = kSVPB_PREV;	break;
			case 3:	m_eDown = kSVPB_PLAY;	break;
			case 4:	m_eDown = kSVPB_STOP;	break;
			case 5:	m_eDown = kSVPB_NEXT;	break;
			case 6:	m_eDown = kSVPB_LAST;	break;
			}
			DrawPlayerButtons(m_eDown);
		}
		else if (!m_arrButtons[m_nPlayerClick-1].PtInRect(point) && (m_eDown != kSVPB_NONE))
		{
			ENM_PLAYER_BUTTONS eTmp = m_eDown;
			m_eDown = kSVPB_NONE;
			DrawPlayerButtons(eTmp);
		}
	}

	CXTResizeDialog::OnMouseMove(nFlags, point);
}

void CSnapPreviewDialog::OnLButtonUp(UINT nFlags, CPoint point)
{
	if (m_nPlayerClick)
	{
		ENM_PLAYER_BUTTONS eTmp = m_eDown;
		m_eDown = kSVPB_NONE;
		DrawPlayerButtons(eTmp);
		::ReleaseCapture();

		switch (m_nPlayerClick)
		{
		case 1:
			if (m_arrButtons[m_nPlayerClick-1].PtInRect(point))
				OnPlayerFirst();
			break;
		case 2:
			if (m_arrButtons[m_nPlayerClick-1].PtInRect(point))
				OnPlayerPrev();
			break;
		case 3:
			if (m_arrButtons[m_nPlayerClick-1].PtInRect(point))
				OnPlayerPlay();
			break;
		case 4:
			if (m_arrButtons[m_nPlayerClick-1].PtInRect(point))
				OnPlayerStop();
			break;
		case 5:
			if (m_arrButtons[m_nPlayerClick-1].PtInRect(point))
				OnPlayerNext();
			break;
		case 6:
			if (m_arrButtons[m_nPlayerClick-1].PtInRect(point))
				OnPlayerLast();
			break;
		}

		m_nPlayerClick = 0;
	}

	CXTResizeDialog::OnLButtonUp(nFlags, point);
}

void CSnapPreviewDialog::OnBnFolderClicked()
{
	CXTBrowseDialog dlg(this);

	if (m_pCD->eState == kPLAYING)
		OnPlayerStop();

	dlg.SetOptions(BIF_NONEWFOLDERBUTTON);
	if (IDOK == dlg.DoModal())
	{
		// Working folder
		m_pCD->strFolder = dlg.GetSelPath();
		if ((m_pCD->strFolder[m_pCD->strFolder.GetLength() - 1] != '\\') &&
				(m_pCD->strFolder[m_pCD->strFolder.GetLength() - 1] != '/'))
		{
			m_pCD->strFolder += "\\";
		}

		if (GetOwner()->SendMessage(UWM_BUTTON_CLICKED, 0, kMSG_CHECK_VALID_FOLDER))	// If folder is OK
		{
			// Enable some controls
			m_sldFrame.EnableWindow();
			m_sldFrame.SetRange(0, m_pCD->nLastFrame);
			m_sldFrame.SetPos(0);
			m_sldSpeed.EnableWindow();

			GetDlgItem(IDC_SVCHK_UPDATETEXT)->EnableWindow(m_pCD->bHasText  ?  TRUE : FALSE);
			GetDlgItem(IDC_SVCHK_UPDATEIMAGES)->EnableWindow(m_pCD->bHasImages  ?  TRUE : FALSE);
			GetDlgItem(IDC_SVCHK_KEEPASPECTR)->EnableWindow(TRUE);

			CString strTmp;
			strTmp.Format("0/%d", m_pCD->nLastFrame);
			SetDlgItemText(IDC_SVSTATIC_FRAME, strTmp);

			int nPos = m_sldSpeed.GetPos();
			strTmp.Format("%0.2f", 1000.f/((101 - abs(nPos))*10.f));
			if (nPos < 0)
				strTmp = "-" + strTmp;
			SetDlgItemText(IDC_SVSTATIC_SPEED, strTmp);

			m_strFolder = m_pCD->strFolder;
			UpdateData(FALSE);

			EnablePlayerButtons();
		}
		else
		{
			AfxMessageBox("Not a valid folder!", MB_OK | MB_ICONEXCLAMATION);

			GetDlgItem(IDC_SVCHK_UPDATETEXT)->EnableWindow(FALSE);
			GetDlgItem(IDC_SVCHK_UPDATEIMAGES)->EnableWindow(FALSE);
			GetDlgItem(IDC_SVCHK_KEEPASPECTR)->EnableWindow(FALSE);

			m_pCD->eState = kUNINITIALIZED;
			m_pCD->vecFiles.clear();

			m_sldFrame.EnableWindow(FALSE);
			m_sldSpeed.EnableWindow(FALSE);

			SetDlgItemText(IDC_SVSTATIC_FRAME, "");
			SetDlgItemText(IDC_SVSTATIC_SPEED, "0.00");

			m_strFolder = "not set";
			UpdateData(FALSE);

			EnablePlayerButtons();
		}
	}
}

void CSnapPreviewDialog::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	if (pScrollBar == reinterpret_cast<CScrollBar *>(&m_sldFrame))
	{
		if (m_pCD->eState == kPLAYING)
			OnPlayerStop();
		if (m_pCD->nCurFrame != m_sldFrame.GetPos())
		{
			m_pCD->nCurFrame = m_sldFrame.GetPos();

			CString strTmp;
			strTmp.Format("%d/%d", m_pCD->nCurFrame, m_pCD->nLastFrame);
			SetDlgItemText(IDC_SVSTATIC_FRAME, strTmp);

			GetOwner()->SendMessage(UWM_BUTTON_CLICKED, 0, kMSG_FRAME_CHANGED);
			EnablePlayerButtons();
		}
	}
	else if (pScrollBar == reinterpret_cast<CScrollBar *>(&m_sldSpeed))
	{
			int nPos = m_sldSpeed.GetPos();

			if (nPos == 0)
				SetDlgItemText(IDC_SVSTATIC_SPEED, "0.00");
			else
			{
				CString strTmp;
				strTmp.Format("%0.2f", 1000.f/((101 - abs(nPos))*10.f));
				if (nPos < 0)
					strTmp = "-" + strTmp;
				SetDlgItemText(IDC_SVSTATIC_SPEED, strTmp);
			}
	}
}

void CSnapPreviewDialog::OnBnClickedSvchkUpdatetext()
{
	UpdateData(TRUE);

	m_pCD->bUpdateTxt = (m_bUpdateText)  ?  true : false;
	GetOwner()->SendMessage(UWM_BUTTON_CLICKED, kMSG_TEXT, kMSG_FORCE_INVALIDATE);
}

void CSnapPreviewDialog::OnBnClickedSvchkUpdateimages()
{
	UpdateData(TRUE);

	m_pCD->bUpdateImages = (m_bUpdateImages)  ?  true : false;
	GetOwner()->SendMessage(UWM_BUTTON_CLICKED, kMSG_VIEW, kMSG_FORCE_INVALIDATE);
}

void CSnapPreviewDialog::OnBnClickedSvchkKeepaspectr()
{
	UpdateData(TRUE);

	m_pCD->bKeepAspect = (m_bKeepAspectR)  ?  true : false;
	GetOwner()->SendMessage(UWM_BUTTON_CLICKED, kMSG_VIEW, kMSG_FORCE_INVALIDATE);
}

void CSnapPreviewDialog::OnBnClickedColorPicker()
{
	m_pCD->clrBack = m_colorPickBtn.GetColor();
	GetOwner()->SendMessage(UWM_BUTTON_CLICKED, kMSG_VIEW, kMSG_FORCE_INVALIDATE);
}

void CSnapPreviewDialog::OnDestroy()
{
	CXTResizeDialog::OnDestroy();

	m_dcPlayerBtns.SelectObject(m_pBmPB);
	m_dcControlBoard.SelectObject(m_pBmCB);
	if (m_pCD->eState == kPLAYING)
		KillTimer(ID_PLAYBACK_TIMER);
}

void CSnapPreviewDialog::OnTimer(UINT_PTR nIDEvent)
{
	int nPos = m_sldSpeed.GetPos();	// -100 ... 100

	if (nPos == 0)	// Stopped state
	{
		CXTResizeDialog::OnTimer(nIDEvent);
		return;
	}

	int nSkipVal = 101 - abs(nPos);					// 100 ... 1
	if	(m_nTimerVar % nSkipVal == 0)
	{
		m_pCD->nCurFrame += (m_sldSpeed.GetPos() < 0)  ?  -1 : 1;
		if (m_pCD->nCurFrame < 0) m_pCD->nCurFrame = m_pCD->nLastFrame;
		else if (m_pCD->nCurFrame > m_pCD->nLastFrame) m_pCD->nCurFrame = 0;
		GetOwner()->SendMessage(UWM_BUTTON_CLICKED, 0, kMSG_INVALIDATE);

		m_sldFrame.SetPos(m_pCD->nCurFrame);
		CString strTmp;
		strTmp.Format("%d/%d", m_pCD->nCurFrame, m_pCD->nLastFrame);
		SetDlgItemText(IDC_SVSTATIC_FRAME, strTmp);
	}

	m_nTimerVar++;
	if (m_nTimerVar > 100)
		m_nTimerVar = 1;

	CXTResizeDialog::OnTimer(nIDEvent);
}

HBRUSH CSnapPreviewDialog::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CXTResizeDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	if ((pWnd->GetDlgCtrlID() == IDC_SVSLIDER_CURFRAME) && (pWnd->IsWindowEnabled()))
		return HBRUSH(m_brSlider.m_hObject);

	return hbr;
}



////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SnapPreviewControls docking frame
IMPLEMENT_DYNAMIC(CSnapPreviewControls, CToolbarDialog)

BEGIN_MESSAGE_MAP(CSnapPreviewControls, CToolbarDialog)
END_MESSAGE_MAP()



// SnapPreviewControls construction & destruction
CSnapPreviewControls::CSnapPreviewControls()
{
}

CSnapPreviewControls::~CSnapPreviewControls()
{
}



// SnapPreviewControls virtual overrides



// SnapPreviewControls message handlers
